classdef callMakeSameSize < polysym
    %CALLMAKESAMESIZE subclass of POLYSYM to access protected method
    %makeSameSize.
    
    properties
        newValue1
        newValue2
    end
    
    methods
        function out = callMakeSameSize(in1,in2)
            
            if nargin > 0
                
                obj1 = polysym(in1);
                obj2 = polysym(in2);
                [obj1,obj2] = makeSameSize(obj1,obj2);
                
                S = num2cell(size(obj2));
                out(S{:}) = callMakeSameSize;
                
                for i=1:numel(out)
                    out(i).newValue1 = obj1(i).Value;
                    out(i).newValue2 = obj2(i).Value;
                end
            end
        end
        
    end
end
